<?php

/**
 * Copyright(c) 2012-2020 E-ICEBLUE Spire.Cloud.Pdf
 * 
 * This program is a free software product. You can redistribute it and/or modify it under the 
 * terms of the GNU Affero General Public License (AGPL) version 3 as published by the Free 
 * Software Foundation, including without limitation the rights to use, copy, modify, merge, 
 * publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to 
 * whom the Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED,INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY,WHETHER IN AN ACTION OF ONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER EALINGS IN THE 
 * SOFTWARE.
 */

namespace Spire\Cloud\Pdf\Sdk\Test\TestHelper;


use Spire\Cloud\Pdf\Sdk\Model\AcroForm\Field;
use Spire\Cloud\Pdf\Sdk\Model\RectangleF;

/**
 * FieldHelper Class table test helper
 *
 * @category Class
 * @package  Spire\Cloud\Pdf\Sdk\Test\TestHelper\FieldHelper
 * @author   E-ICEBLUE
 */
class FieldHelper
{
    public function GetField($testType, $f_type)
    {
        switch ($testType) {
            case  "Required":
                return $this->SimpleField($f_type);

            case  "MappingName":
                return $this->MappingNameField($f_type);

            case  "ToolTip":
                return $this->ToolTipField($f_type);

            case  "SelectedItems":
                return $this->SelectedItemsField($f_type);
        }
        return null;
    }

    private function SimpleField($f_type)
    {
        $field = $this->SetRequiredProperties($f_type);
        return $field;
    }
    private function MappingNameField($f_type)
    {
        $field = $this->SetRequiredProperties($f_type);
        $field->setMappingName ($f_type . "MapingName");
        return $field;
    }

    private function ToolTipField($f_type)
    {
        $field = $this->SetRequiredProperties($f_type);
        $field->setMappingName ($f_type . "MapingName");
        $field->setToolTip ($f_type . "ToolTip");
        return $field;
    }

    private function SelectedItemsField($f_type)
    {
        $field = $this->SetRequiredProperties($f_type);
        $field->setMappingName ($f_type . "MapingName");
        $field->setToolTip ($f_type . "ToolTip");
        $field->setSelectedItems (array(0, 2));
        return $field;
    }

    private function SetRequiredProperties($f_type)
    {
        $values = array();
        if ($f_type == "Check") {
            $values[] = "true";
        } else if ($f_type == "PushButton") {
            $values[] = "Push It";
        } else {
            $values[] = "alibaba";
        }
        $values[] = "tencent";
        $values[] = "apple";
        $values[] = "google";

        $PageIndex = 1;
        $Name = $this->GetName($f_type);
        $Bounds = new RectangleF(['x' => 300, 'y' => 500, 'width' => 150, 'height' => 60]);

        if ($f_type == "Check") {
            $Bounds = new RectangleF(['x' => 300, 'y' => 500, 'width' => 15, 'height' => 15]);
        }
        if ($f_type == "PushButton") {
            $Bounds = new RectangleF(['x' => 300, 'y' => 500, 'width' => 40, 'height' => 22]);
        }
        return new Field(['bounds' => $Bounds, 'values' => $values, 'name' => $Name, 'type' => $f_type, 'page_index' => $PageIndex]);
    }


    private function GetName($f_type)
    {
        switch ($f_type) {
            case  "Text":
                return "state";

            case  "Check":
                return "agreement_of_terms";

            case  "List":
                return "email_format";

            case  "ComboBox":
                return "title";

            case  "PushButton":
                return "submit";
        }
        return null;
    }
}
