<?php

/**
 * Copyright(c) 2012-2020 E-ICEBLUE Spire.Cloud.Pdf
 * 
 * This program is a free software product. You can redistribute it and/or modify it under the 
 * terms of the GNU Affero General Public License (AGPL) version 3 as published by the Free 
 * Software Foundation, including without limitation the rights to use, copy, modify, merge, 
 * publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to 
 * whom the Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED,INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY,WHETHER IN AN ACTION OF ONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER EALINGS IN THE 
 * SOFTWARE.
 */

namespace Spire\Cloud\Pdf\Sdk\Test\TestHelper;

use Spire\Cloud\Pdf\Sdk\Model\AcroForm\ComboBoxField;
use Spire\Cloud\Pdf\Sdk\Model\RectangleF;

/**
 * ComboBoxHelper Class table test helper
 *
 * @category Class
 * @package  Spire\Cloud\Pdf\Sdk\Test\TestHelper\ComboBoxHelper
 * @author   E-ICEBLUE
 */
class ComboBoxHelper
{
    public function GetComboBoxField($testType)
    {
        switch ($testType) {
            case  "Required":
                return $this->SimpleComboBoxField();

            case  "MappingName":
                return $this->MappingNameComboBoxField();

            case  "SelectedIndexs":
                return $this->SelectedIndexsComboBoxField();

            case  "ToolTip":
                return $this->ToolTipComboBoxField();

            case  "Value":
                return $this->ValuesComboBoxField();
        }
        return null;
    }

    private function SimpleComboBoxField()
    {
        $comboBox = $this->SetRequiredProperties();
        return $comboBox;
    }

    private function MappingNameComboBoxField()
    {
        $comboBox = $this->SetRequiredProperties();
        $comboBox->setMappingName("comboBoxMapingName");
        return $comboBox;
    }

    private function ToolTipComboBoxField()
    {
        $comboBox = $this->SetRequiredProperties();
        $comboBox->setMappingName("comboBoxMapingName");
        $comboBox->setToolTip ("comboBoxToolTip");
        return $comboBox;
    }
    private function ValuesComboBoxField()
    {
        $comboBox = $this->SetRequiredProperties();
        $comboBox->setMappingName("comboBoxMapingName");
        $comboBox->setToolTip ("comboBoxToolTip");
        $values = array("PDF", "XLS", "PPT", "DOC", "DOCX");
        $comboBox->setValues($values);
        return $comboBox;
    }
    private function SelectedIndexsComboBoxField()
    {
        $comboBox = $this->SetRequiredProperties();
        $comboBox->setMappingName("comboBoxMapingName");
        $comboBox->setToolTip ("comboBoxToolTip");
        $values = array("PDF", "XLS", "PPT", "DOC", "DOCX");
        $comboBox->setValues($values);
        $comboBox->setSelectedIndexs(array(1, 2));
        return $comboBox;
    }
    private function SetRequiredProperties()
    {
        $ComboBoxFlags = array();
        $ComboBoxFlags[] = "Edit";
        $ComboBoxFlags[] = "CommitOnSelChange";

        $Bounds = new RectangleF(['x' => 100, 'y' => 250, 'width' => 150, 'height' => 25]);
        $Name = "title";
        $PageIndex = 1;

        return new ComboBoxField(['combo_box_flags' => $ComboBoxFlags, 'bounds' => $Bounds, 'name' => $Name, 'page_index' => $PageIndex]);
    }
}
