<?php

/**
 * Copyright(c) 2012-2020 E-ICEBLUE Spire.Cloud.Pdf
 * 
 * This program is a free software product. You can redistribute it and/or modify it under the 
 * terms of the GNU Affero General Public License (AGPL) version 3 as published by the Free 
 * Software Foundation, including without limitation the rights to use, copy, modify, merge, 
 * publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to 
 * whom the Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED,INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY,WHETHER IN AN ACTION OF ONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER EALINGS IN THE 
 * SOFTWARE.
 */

namespace Spire\Cloud\Pdf\Sdk\Test\TestHelper;


use Spire\Cloud\Pdf\Sdk\Model\AcroForm\CheckBoxField;
use Spire\Cloud\Pdf\Sdk\Model\RectangleF;

/**
 * CheckBoxHelper Class table test helper
 *
 * @category Class
 * @package  Spire\Cloud\Pdf\Sdk\Test\TestHelper\CheckBoxHelper
 * @author   E-ICEBLUE
 */
class CheckBoxHelper
{
    public function GetCheckBoxField($testType)
    {
        switch ($testType) {
            case "Required":
                return $this->SimpleCheckBoxField();

            case "MappingName":
                return $this->MappingNameCheckBoxField();

            case "ToolTip":
                return $this->ToolTipCheckBoxField();

            case "Value":
                return $this->ValuesCheckBoxField();
        }
        return null;
    }
    private function SimpleCheckBoxField()
    {
        $CheckBox = $this->SetRequiredProperties();
        return $CheckBox;
    }
    private function MappingNameCheckBoxField()
    {
        $CheckBox = $this->SetRequiredProperties();
        $CheckBox->setMappingName("CheckBoxMapingName");
        return $CheckBox;
    }

    private function ToolTipCheckBoxField()
    {
        $CheckBox = $this->SetRequiredProperties();
        $CheckBox->setMappingName("CheckBoxMapingName");
        $CheckBox->setToolTip("CheckBoxToolTip");
        return $CheckBox;
    }
    private function ValuesCheckBoxField()
    {
        $CheckBox = $this->SetRequiredProperties();
        $CheckBox->setMappingName("CheckBoxMapingName");
        $CheckBox->setToolTip("CheckBoxToolTip");
        $CheckBox->setValue("true");
        return $CheckBox;
    }
    private function SetRequiredProperties()
    {
        $CheckBoxFlags = array();
        $CheckBoxFlags[] = "NoExport";
        $CheckBoxFlags[] = "Required";
        $Bounds = new RectangleF(['x' => 300, 'y' => 500, 'width' => 20, 'height' => 20]);
        $Name = "agreement_of_terms";
        $PageIndex = 1;
        return new CheckBoxField(['check_box_flags' => $CheckBoxFlags, 'bounds' => $Bounds, 'name' => $Name, 'page_index' => $PageIndex]);
    }
}
