﻿using Spire.Cloud.Word.Sdk.Api;
using Spire.Cloud.Word.Sdk.Client;
using System;
using System.IO;
using Newtonsoft.Json.Linq;

namespace SpireCloudSDK
{
    class Search_
    {
        static string appId_AI = "you ai id";
        static string appKey_AI = "you ai key";
        static string baseUrl_AI = "base url";
        static Configuration wordConfiguration_AI = new Configuration(appId_AI, appKey_AI, baseUrl_AI);
        static WordAIApi wordAIApi = new WordAIApi(wordConfiguration_AI);

        public static void Search()
        {
            string question = "Write a song about winter";
            string language = "English";
            string response = wordAIApi.Search(question, language);
        }

        public static void Search_EnableHistory()
        {
            string question = "How many days are there in a year?";
            bool enableHistory = true;
            string language = "English";
            string response = wordAIApi.Search(question, language, enableHistory);

            string destFilePath = "local_output/Search_EnableHistory.txt";
            File.WriteAllText(response, destFilePath);
        }
        public static void Search_EnableHistoryWidthId()
        {
            string question = "What question did I ask?";
            bool enableHistory = true;
            string conversationID = GetConversationID("local_output/Search_EnableHistory.txt");
            string response = wordAIApi.AskQuestion(question, enableHistory, conversationID);
        }
        public static void Search_UnableHistory()
        {
            string question = "To recommend the way to play in spring, please return to markdown format";
            bool enableHistory = false;
            string language = "English";
            string response = wordAIApi.Search(question, language, enableHistory);
        }

        public static void Search_UnableHistoryWidthId()
        {
            string question = "What question did I ask?";
            bool enableHistory = false;
            string language = "English";
            string conversationID = GetConversationID("local_output/Search_EnableHistory.txt");
            string response = wordAIApi.Search(question, language, enableHistory, conversationID);
        }
        static string GetConversationID(string filePath)
        {
            string lastLine = string.Empty;
            try
            {
                using (StreamReader reader = new StreamReader(filePath, System.Text.Encoding.UTF8))
                {
                    string line;
                    while ((line = reader.ReadLine()) != null)
                    {
                        lastLine = line;
                    }
                }
                if (!string.IsNullOrEmpty(lastLine))
                {
                    JObject jsonObject = JObject.Parse(lastLine);

                    string conversationId = (string)jsonObject["conversationID"];
                    return conversationId; 
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine($"An error occurred: {ex.Message}");
            }
            return string.Empty;
        }
    }
}
