﻿using Spire.Cloud.Storage.Sdk.Api;
using Spire.Cloud.Storage.Sdk.Client;
using Spire.Cloud.Storage.Sdk.Model;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CloudStorage
{
    class FileApiDemo
    {
        static string appId = "your id";
        static string appKey = "your key";
        static string baseUrl = "https://api.e-iceblue.cn";
        static Configuration configuration = new Configuration(appId, appKey, baseUrl);
        static FileApi fileApi = new FileApi(configuration);
        public static void CopyFile()
        {
            string srcPath = "input/test.docx";
            string destPath = "input/test/test2.docx";
            string srcStorageName = null;
            string destStorageName = null;
            fileApi.CopyFile(srcPath, destPath, srcStorageName, destStorageName);
        }
        public static void DeleteFile()
        {
            string path = "input/test.docx"; ;
            string storageName = null;
            fileApi.DeleteFile(path, storageName);
        }
        public static void DownloadFile()
        {
            string path = "input/test.pptx"; 
            string storageName = null;
            var response = fileApi.DownloadFile(path, storageName);
        }
        public static void MoveFile()
        {
            string srcPath = "input/test.pptx";
            string destPath = "output/test/test.pptx";
            string srcStorageName = null;
            string destStorageName = null;
            fileApi.MoveFile(srcPath, destPath, srcStorageName, destStorageName);
        }
        public static void UploadFile()
        {
            string path = "input/new.pptx";
            string localFilePath = "D:/input/test3.pptx";
            System.IO.Stream data = new FileStream(localFilePath, FileMode.Open);
            string storageName = null;
            var response = fileApi.UploadFile(path, data, storageName);
            data.Close();
        }
        public static void GetSignatureUrl()
        {
            string path = "input/new.pptx";
            string storageName = null;
            decimal expiration = 6000;
            var response = fileApi.GetSignatureUrl(path, expiration, storageName);
        }
    }
}
