﻿using Spire.Cloud.Powerpoint.Sdk.Client;
using Spire.Cloud.Powerpoint.Sdk.Api;
using Newtonsoft.Json.Linq;
using System.IO;
using System;

namespace SpireCloudSDK
{ 
    class Ask_
    {
        static string appId_AI = "you ai id";
        static string appKey_AI = "you ai key";
        static string baseUrl_AI = "base url";
        static Configuration pptConfiguration_AI = new Configuration(appId_AI, appKey_AI, baseUrl_AI);
        static PowerPointAIApi pptAIApi = new PowerPointAIApi(pptConfiguration_AI);

        public static void Ask()
        {
            string fileName = "sample.txt";
            string question = "写一首关于春天的五言绝句";
            string conversationID = "";
            string folder = "output";
            pptAIApi.ASKWithHttpInfo(fileName, question, null, conversationID, folder, null);
        }
        public static void Ask_EnableHistory()
        {
            string fileName = "Ask_EnableHistory.txt";
            string question = "推荐春天游玩的方式，请返回markdown格式";
            bool enableHistory = true;
            string folder = "output";
            pptAIApi.ASKWithHttpInfo(fileName, question, enableHistory, null, folder);
        }
        public static void Ask_EnableHistoryWidthId()
        {
            string fileName = "Ask_EnableHistoryWidthId.txt";
            string question = "推荐春天游玩的方式，请返回markdown格式";
            bool enableHistory = true;
            string conversationID = GetConversationID("output/Ask_EnableHistory.txt");
            string folder = "output";
           pptAIApi.ASKWithHttpInfo(fileName, question, enableHistory, conversationID, folder);
        }
        public static void Ask_UnableHistory()
        {
            string fileName = "Ask_UnableHistory.txt";
            string question = "推荐春天游玩的方式，请返回markdown格式";
            bool enableHistory = false;
            string folder = "output";
            pptAIApi.ASKWithHttpInfo(fileName, question, enableHistory, null, folder);
        }
        public static void Ask_UnableHistoryWithId()
        {
            string fileName = "Ask_UnableHistoryWithId.txt";
            string question = "刚才问了什么？";
            bool enableHistory = false;
            string conversationID = GetConversationID("output/Ask_EnableHistory.txt");
            string folder = "output";
            pptAIApi.ASKWithHttpInfo(fileName, question, enableHistory, conversationID, folder);
        }
        static string GetConversationID(string filePath)
        {
            string lastLine = string.Empty;
            try
            {
                using (StreamReader reader = new StreamReader(filePath, System.Text.Encoding.UTF8))
                {
                    string line;
                    while ((line = reader.ReadLine()) != null)
                    {
                        lastLine = line;
                    }
                }
                if (!string.IsNullOrEmpty(lastLine))
                {
                    JObject jsonObject = JObject.Parse(lastLine);

                    string conversationId = (string)jsonObject["conversationID"];
                    return conversationId;
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine($"An error occurred: {ex.Message}");
            }
            return string.Empty;
        }
    }
}
