﻿using Spire.Cloud.Pdf.Sdk.Api;
using Spire.Cloud.Pdf.Sdk.Client;
using Spire.Cloud.Pdf.Sdk.Model;
using System;
using System.IO;


namespace CloudPdf
{
    class PdfWartermarkApiDemo
    {
        static String appId = "your id";
        static String appKey = "your key";
        static String baseUrl = "https://api.e-iceblue.cn";
        static Configuration PdfConfiguration = new Configuration(appId, appKey, baseUrl);
        static PdfWartermarkApi PdfWartermarkApi = new PdfWartermarkApi(PdfConfiguration);

        public static void AddTextWartermark()
        {           
            string name = "AddTextWartermark.pdf";
            string outPath = "output/AddTextWartermark_output.pdf";
            int pageNumber = 1;
            string folder = "input";
            Text text = new Text("This is a test.",
                 new Font(Font.FontTypeEnum.Standard, "Helvetica", 12, Font.FontStyleEnum.Regular),new RectangleF(10, 10, 100, 50));
            TextWartermark textWartermark = new TextWartermark(new RectangleF(10, 10, 500, 500), text, 2, 3, 0.3f, 45);
            text.BackgroundColor = new Color(100, 0, 0, 255);
            text.ForegroundColor = new Color(100, 255, 0, 0);
            string password = null;
            string storage = null;
            PdfWartermarkApi.AddTextWartermark(name, outPath, pageNumber, textWartermark,  folder, storage, password);

        }
        public static void AddImageWartermark()
        {
            string name = "AddImageWartermark.pdf";
            string outPath = "output/AddImageWartermark_output.pdf";
            int pageNumber = 1;
            using (Stream file = new FileStream("D:/inputFile/Attachment.jpg", FileMode.Open))
            {
                float x = 10;
                float y = 10;
                float? width = 500;
                float? height = 500;
                string password = null;
                string storage = null;
                string folder = "input";
                PdfWartermarkApi.AddImageWartermark(name, outPath, pageNumber, file, x, y, width, height, folder, storage, password);
            }
        }
    }
}
