﻿using Spire.Cloud.Pdf.Sdk.Api;
using Spire.Cloud.Pdf.Sdk.Client;
using Spire.Cloud.Pdf.Sdk.Model;
using System;
using System.Collections.Generic;


namespace CloudPdf
{
    class PdfPropertiesApiDemo
    {
        static String appId = "your id";
        static String appKey = "your key";
        static String baseUrl = "https://api.e-iceblue.cn";
        static Configuration PdfConfiguration = new Configuration(appId, appKey, baseUrl);
        static PdfPropertiesApi pdfPropertiesApi = new PdfPropertiesApi(PdfConfiguration);
        public static void AddOrUpdateProperties()
        {
            string name = "AddOrUpdateProperties.pdf";
            string outPath = "output/AddOrUpdateProperties_output.pdf";
            DocumentProperties properties = new DocumentProperties();
            properties.List = new List<DocumentProperty>();
            //buildin properties
            properties.List.Add(new DocumentProperty("author", "Simon"));
            properties.List.Add(new DocumentProperty("creator", "Simon2"));
            properties.List.Add(new DocumentProperty("keywords", "the keywords"));
            properties.List.Add(new DocumentProperty("producer", "Spire.pdf"));
            properties.List.Add(new DocumentProperty("subject", "the subject"));
            properties.List.Add(new DocumentProperty("title", "the title"));
            //customized properties
            properties.List.Add(new DocumentProperty("customizedProperty1", "the customizedProperty1"));
            properties.List.Add(new DocumentProperty("customizedProperty2", "the customizedProperty2"));
            properties.List.Add(new DocumentProperty("Name", " Lisa"));

            string folder = "input";
            string password = null;
            string storage = null;
            pdfPropertiesApi.AddOrUpdateProperties(name, outPath, properties, folder, storage, password);
        }

        public static void DeleteProperties()
        {
            string name = "DeleteProperties.pdf";
            string outPath = "output/DeleteProperties_output.pdf";
            string folder = "input";
            string password = null;
            string storage = null;
            pdfPropertiesApi.DeleteProperties(name, outPath, folder, storage, password);
        }

        public static void GetProperties()
        {
            Configuration PdfConfiguration = new Configuration(appId, appKey, baseUrl);
            PdfPropertiesApi pdfPropertiesApi = new PdfPropertiesApi(PdfConfiguration);

            string name = "GetProperties.pdf";
            string folder = "input";
            string password = null;
            string storage = null;
            var response = pdfPropertiesApi.GetProperties(name, folder, storage, password);
        }

    }
}
