﻿using Spire.Cloud.Pdf.Sdk.Api;
using Spire.Cloud.Pdf.Sdk.Client;
using Spire.Cloud.Pdf.Sdk.Model;
using System;

namespace CloudPdf
{
    class PdfPagesApiDemo
    {
        static String appId = "your id";
        static String appKey = "your key";
        static String baseUrl = "https://api.e-iceblue.cn";
        static Configuration PdfConfiguration = new Configuration(appId, appKey, baseUrl);
        static PdfPagesApi pdfPagesApi = new PdfPagesApi(PdfConfiguration);
        public static void AddPage() 
        {         
            string name = "AddPage.pdf";
            string outPath = "output/AddPage_output.pdf";
            Page page = new Page();
            page.Rect = new RectangleF(0, 0, 500, 800);
            string folder = "input";
            string storage = null;
            string password = null;
            pdfPagesApi.AddPage(name, outPath, page, folder, storage, password);
        }

        public static void DeletePage()
        {
            string name = "DeletePage.pdf";
            string outPath = "output/DeletePage_output.pdf";
            int pageNumber = 1;
            string folder = "input";
            string storage = null;
            string password = null;
            pdfPagesApi.DeletePage(name, outPath, pageNumber, folder, storage, password);
        }

        public static void GetPageInfo()
        {
            string name = "GetPageInfo.pdf";
            int pageNumber = 1;
            string folder = "input";
            string storage = null;
            string password = null;
            var response = pdfPagesApi.GetPageInfo(name, pageNumber, folder, storage, password);
        }

        public static void GetPagesInfo()
        {
            string name = "GetPagesInfo.pdf";
            string folder = "input";
            string password = null;
            string storage = null;
            var response = pdfPagesApi.GetPagesInfo(name, folder, storage, password);
        }
    }
}
