﻿using Spire.Cloud.Pdf.Sdk.Api;
using Spire.Cloud.Pdf.Sdk.Client;
using System;
using System.IO;

namespace CloudPdf
{
    class PdfImagesApiDemo
    {
        static String appId = "your id";
        static String appKey = "your key";
        static String baseUrl = "https://api.e-iceblue.cn";
        static Configuration pdfConfiguration = new Configuration(appId, appKey, baseUrl);
        static PdfImagesApi pdfImagesApi = new PdfImagesApi(pdfConfiguration);
        public static void AddImage()
        {
            string name = "AddImage.pdf";
            string outPath = "output/AddImage.pdf";

            int pageNumber = 1;
            using (System.IO.Stream file = new FileStream("D:/inputFile/AddImage.jpg", FileMode.Open))
            {
                float x = 10;
                float y = 10;
                float? width = null;
                float? height = null;
                string password = null;
                string folder = "input";
                string storage = null;
                pdfImagesApi.AddImage(name, outPath, pageNumber, file, x, y, width, height, folder,storage, password);
            }
        }
        public static void AddImageWithSize()
        {
            string name = "AddImageWithSize.pdf";
            string outPath = "output/AddImageWithSize.pdf";
            int pageNumber = 1;
            using (System.IO.Stream file = new FileStream("D:s/inputFile/AddImageWithSize.jpg", FileMode.Open))
            {
                float x = 10;
                float y = 10;
                float width = 300;
                float height = 300;
                string password = null;
                string folder = "input";
                string storage = null;
                pdfImagesApi.AddImage(name, outPath, pageNumber, file, x, y, width, height, folder, storage, password);
            }
        }

        public static void ExtractImage()
        {
            string name = "ExtractImages.pdf";
            string outPath = "output/ExtractImages";
            int pageNumber = 1;

            string password = null;
            string storage = null;
            string folder = "input";
            pdfImagesApi.ExtractImages(name, outPath, pageNumber, folder, storage, password);
        }
    }
}
