﻿using Spire.Cloud.Pdf.Sdk.Api;
using Spire.Cloud.Pdf.Sdk.Client;
using Spire.Cloud.Pdf.Sdk.Model;
using System;
using System.Collections.Generic;

namespace CloudPdf
{
    class PdfDocumentApiDemo
    {
        static String appId = "your id";
        static String appKey = "your key";
        static String baseUrl = "https://api.e-iceblue.cn";
        static Configuration pdfConfiguration = new Configuration(appId, appKey, baseUrl);
        static PdfDocumentApi pdfDocumentApi = new PdfDocumentApi(pdfConfiguration);
        public static void CreateEmptyDocument()
        {
            string name = "CreateEmptyDocument.pdf";
            string folder = "output";
            pdfDocumentApi.CreateEmptyDocument(name, folder);
        }

        public static void GetDocumentInfo()
        {
            string name = "GetDocumentInfo.pdf";
            string folder = "input";
            string password = null;
            string storage = null;
            Document response = pdfDocumentApi.GetDocumentInfo(name, folder, storage, password);
        }

        public static void MergeDocument()
        {
            string name = "MergeDocument.pdf";
            string folder = "output";
            List<string> files = new List<string>();
            files.Add("input/Sample.pdf");
            files.Add("input/Sample_attachments.pdf");
            pdfDocumentApi.MergeDocument(name, files, folder);
        }

        public static void SplitDocument()
        {
            string name = "Split.pdf";
            string folder = "input";
            string storage = null;
            string outPath = "output/Split";
            pdfDocumentApi.SplitDocument(name, outPath, folder, storage);
        }
    }
}
