﻿using Spire.Cloud.Pdf.Sdk.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using static Spire.Cloud.Pdf.Sdk.Model.TextBoxField;

namespace Spire.Cloud.Pdf.Sdk.TestHelper
{
    internal class TextBoxHelper
    {

        internal enum TextBoxFieldTestType
        {
            Required,
            MappingName,
            ToolTip,
            Value,
            ForeColor,
            DefaultValue,
            MaxLength,
            HighlightMode,
            TextAlignment,
        }
   
        public TextBoxField GetTextBoxField(TextBoxFieldTestType testType)
        {
            switch (testType)
            {
                case TextBoxFieldTestType.Required:
                    return SimpleTextBoxField();

                case TextBoxFieldTestType.MappingName:
                    return MappingNameTextBoxField();

                case TextBoxFieldTestType.ToolTip:
                    return ToolTipTextBoxField();

                case TextBoxFieldTestType.Value:
                    return ValuesTextBoxField();

                case TextBoxFieldTestType.ForeColor:
                    return ForeColorTextBoxField();

                case TextBoxFieldTestType.DefaultValue:
                    return DefaultValueTextBoxField();

                case TextBoxFieldTestType.MaxLength:
                    return MaxLengthTextBoxField();

                case TextBoxFieldTestType.HighlightMode:
                    return HighlightModeTextBoxField();

                case TextBoxFieldTestType.TextAlignment:
                    return TextAlignmentTextBoxField();
            }
            return null;
        }

 

        private TextBoxField SimpleTextBoxField()
        {
            TextBoxField TextBox = SetRequiredProperties();
            return TextBox;
        }
        private TextBoxField MappingNameTextBoxField()
        {
            TextBoxField TextBox = SetRequiredProperties();
            TextBox.MappingName = "TextBoxMapingName";
            return TextBox;
        }

        private TextBoxField ToolTipTextBoxField()
        {
            TextBoxField TextBox = SetRequiredProperties();
            TextBox.MappingName = "TextBoxMapingName";
            TextBox.ToolTip = "TextBoxToolTip";
            return TextBox;
        }
        private TextBoxField ValuesTextBoxField()
        {
            TextBoxField TextBox = SetRequiredProperties();
            TextBox.MappingName = "TextBoxMapingName";
            TextBox.ToolTip = "TextBoxToolTip";
            TextBox.Value = "textBoxNewLineText";
            return TextBox;
        }

        private TextBoxField TextAlignmentTextBoxField()
        {
            TextBoxField TextBox = SetRequiredProperties();
            TextBox.MappingName = "TextBoxMapingName";
            TextBox.ToolTip = "TextBoxToolTip";
            TextBox.Value = "textBoxNewLineText";
            TextBox.TextAlignment = TextAlignmentEnum.Center;
            return TextBox;
        }

        private TextBoxField HighlightModeTextBoxField()
        {
            TextBoxField TextBox = SetRequiredProperties();
            TextBox.MappingName = "TextBoxMapingName";
            TextBox.ToolTip = "TextBoxToolTip";
            TextBox.Value = "textBoxNewLineText";
            TextBox.TextAlignment = TextAlignmentEnum.Center;
            TextBox.HighlightMode = HighlightModeEnum.NoHighlighting;
            return TextBox;
        }

        private TextBoxField MaxLengthTextBoxField()
        {
            TextBoxField TextBox = SetRequiredProperties();
            TextBox.MappingName = "TextBoxMapingName";
            TextBox.ToolTip = "TextBoxToolTip";
            TextBox.Value = "textBoxNewLineText";
            TextBox.TextAlignment = TextAlignmentEnum.Center;
            TextBox.HighlightMode = HighlightModeEnum.NoHighlighting;
            TextBox.MaxLength = 250;
            return TextBox;
        }

        private TextBoxField DefaultValueTextBoxField()
        {
            TextBoxField TextBox = SetRequiredProperties();
            TextBox.MappingName = "TextBoxMapingName";
            TextBox.ToolTip = "TextBoxToolTip";
            TextBox.Value = "textBoxNewLineText";
            TextBox.TextAlignment = TextAlignmentEnum.Center;
            TextBox.HighlightMode = HighlightModeEnum.NoHighlighting;
            TextBox.MaxLength = 250;
            TextBox.DefaultValue = "DefaultValue";
            return TextBox;
        }

        private TextBoxField ForeColorTextBoxField()
        {
            TextBoxField TextBox = SetRequiredProperties();
            TextBox.MappingName = "TextBoxMapingName";
            TextBox.ToolTip = "TextBoxToolTip";
            TextBox.Value = "textBoxNewLineTexttextBoxNewLineTexttextBoxNewLineTexttextBoxNewLineTexttextBoxNewLineTexttextBoxNewLineTexttextBoxNewLineText";
            TextBox.TextAlignment = TextAlignmentEnum.Center;
            TextBox.HighlightMode = HighlightModeEnum.NoHighlighting;
            TextBox.MaxLength = 250;
            TextBox.DefaultValue = "DefaultValue";
            TextBox.ForeColor = new Color (255,110,110,110);
            return TextBox;
        }
        private TextBoxField SetRequiredProperties()
        {
            List<TextBoxFlagsEnum> TextBoxFlags = new List<TextBoxFlagsEnum>();
            TextBoxFlags.Add(TextBoxFlagsEnum.NoExport);
            TextBoxFlags.Add(TextBoxFlagsEnum.Multiline);
            TextBoxFlags.Add(TextBoxFlagsEnum.DoNotSpellCheck);

            RectangleF Bounds = new RectangleF(300, 500, 150, 80);
            string Name = "fax";
            int PageIndex = 1;

            return new TextBoxField(TextBoxFlags, Name, PageIndex, Bounds);
        }
    }
}
