﻿using Spire.Cloud.Pdf.Sdk.Model;
using System.Collections.Generic;

namespace Spire.Cloud.Pdf.Sdk.TestHelper
{
    internal class ListBoxHelper
    {
        internal enum ListBoxFieldTestType
        {
            Required,
            MappingName,
            ToolTip,
            Values,
            SelectedIndexs,
        }

        public ListBoxField GetListBoxField(ListBoxFieldTestType testType)
        {
            switch (testType)
            {
                case ListBoxFieldTestType.Required:
                    return SimpleListBoxField();

                case ListBoxFieldTestType.MappingName:
                    return MappingNameListBoxField();

                case ListBoxFieldTestType.SelectedIndexs:
                    return SelectedIndexsListBoxField();

                case ListBoxFieldTestType.ToolTip:
                    return ToolTipListBoxField();

                case ListBoxFieldTestType.Values:
                    return ValuesListBoxField();
            }
            return null;
        }

        private ListBoxField SimpleListBoxField()
        {
            ListBoxField ListBox = SetRequiredProperties();
            return ListBox;
        }
        private ListBoxField MappingNameListBoxField()
        {
            ListBoxField ListBox = SetRequiredProperties();
            ListBox.MappingName = "ListBoxMapingName";
            return ListBox;
        }

        private ListBoxField ToolTipListBoxField()
        {
            ListBoxField ListBox = SetRequiredProperties();
            ListBox.MappingName = "ListBoxMapingName";
            ListBox.ToolTip = "ListBoxToolTip";
            return ListBox;
        }
        private ListBoxField ValuesListBoxField()
        {
            ListBoxField ListBox = SetRequiredProperties();
            ListBox.MappingName = "ListBoxMapingName";
            ListBox.ToolTip = "ListBoxToolTip";
            List<string> values = new List<string>() { "PDF", "XLS", "PPT", "DOC", "DOCX" };
            ListBox.Values = values;
            return ListBox;
        }
        private ListBoxField SelectedIndexsListBoxField()
        {
            ListBoxField ListBox = SetRequiredProperties();
            ListBox.MappingName = "ListBoxMapingName";
            ListBox.ToolTip = "ListBoxToolTip";
            List<string> values = new List<string>() { "PDF", "XLS", "PPT", "DOC", "DOCX" };
            ListBox.Values = values;
            ListBox.SelectedIndexs = new List<int?>() { (int)1, (int)2 };
            return ListBox;
        }
        private ListBoxField SetRequiredProperties()
        {
            List<ListBoxField.ListBoxFlagsEnum> ListBoxFlags = new List<ListBoxField.ListBoxFlagsEnum>();
            ListBoxFlags.Add(ListBoxField.ListBoxFlagsEnum.MultiSelect);
            ListBoxFlags.Add(ListBoxField.ListBoxFlagsEnum.CommitOnSelChange);

            RectangleF Bounds = new RectangleF(100, 250, 150, 60);
            string Name = "email_format";
            int PageIndex = 1;

            return new ListBoxField(ListBoxFlags, Bounds, Name, PageIndex);
        }

    }
}
