﻿using Spire.Cloud.Pdf.Sdk.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using static Spire.Cloud.Pdf.Sdk.Model.Field;

namespace Spire.Cloud.Pdf.Sdk.TestHelper
{
    internal class FieldHelper
    {
        internal enum FieldTestType
        {
            Required,
            MappingName,
            ToolTip,
            SelectedItems,
        }
        public Field GetField(FieldTestType testType)
        {
            switch (testType)
            {
                case FieldTestType.Required:
                    return SimpleField();

                case FieldTestType.MappingName:
                    return MappingNameField();

                case FieldTestType.ToolTip:
                    return ToolTipField();

                case FieldTestType.SelectedItems:
                    return SelectedItemsField();
            }
            return null;
        }

        private Field SimpleField()
        {
            Field field = SetRequiredProperties();
            return field;
        }
        private Field MappingNameField()
        {
            Field field = SetRequiredProperties();
            field.MappingName = f_type + "MapingName";
            return field;
        }

        private Field ToolTipField()
        {
            Field field = SetRequiredProperties();
            field.MappingName = f_type + "MapingName";
            field.ToolTip = f_type + "ToolTip";
            return field;
        }

        private Field SelectedItemsField()
        {
            Field field = SetRequiredProperties();
            field.MappingName = f_type + "MapingName";
            field.ToolTip = f_type + "ToolTip";
            field.SelectedItems = new List<int?>() { 0, 2 };
            return field;
        }

        private Field SetRequiredProperties()
        {
            List<string> values = new List<string>();
            if (f_type == TypeEnum.Check)
            {
                values.Add("true");
            }
            else if (f_type == TypeEnum.PushButton)
            {
                values.Add("Push It");
            }
            else
            {
                values.Add("alibaba");
            }
            values.Add("tencent");
            values.Add("apple");
            values.Add("google");

            int PageIndex = 1;
            string Name = GetName();
            RectangleF Bounds = new RectangleF(300, 500, 150, 60);

            if (f_type == TypeEnum.Check)
            {
                Bounds = new RectangleF(300, 500, 15, 15);
            }
            if (f_type == TypeEnum.PushButton)
            {
                Bounds = new RectangleF(300, 500, 40, 22);
            }
            return new Field(Bounds, values, Name, f_type, PageIndex);
        }

        internal TypeEnum f_type = TypeEnum.Check;

        private string GetName()
        {
            switch (f_type)
            {
                case TypeEnum.Text:
                    return "state";

                case TypeEnum.Check:
                    return "agreement_of_terms";

                case TypeEnum.List:
                    return "email_format";

                case TypeEnum.ComboBox:
                    return "title";

                case TypeEnum.PushButton:
                    return "submit";
            }
            return null;
        }
    }
}
