﻿using Spire.Cloud.Pdf.Sdk.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using static Spire.Cloud.Pdf.Sdk.Model.ComboBoxField;

namespace Spire.Cloud.Pdf.Sdk.TestHelper
{
    internal class ComboBoxHelper
    {
        internal enum ComboBoxFieldTestType
        {
            Required,
            MappingName,
            ToolTip,
            Values,
            SelectedIndexs,
        }

        public ComboBoxField GetComboBoxField(ComboBoxFieldTestType testType)
        {
            switch (testType)
            {
                case ComboBoxFieldTestType.Required:
                    return SimpleComboBoxField();

                case ComboBoxFieldTestType.MappingName:
                    return MappingNameComboBoxField();

                case ComboBoxFieldTestType.SelectedIndexs:
                    return SelectedIndexsComboBoxField();

                case ComboBoxFieldTestType.ToolTip:
                    return ToolTipComboBoxField();

                case ComboBoxFieldTestType.Values:
                    return ValuesComboBoxField();
            }
            return null;
        }

        private ComboBoxField SimpleComboBoxField()
        {
            ComboBoxField comboBox = SetRequiredProperties();
            return comboBox;
        }
        private ComboBoxField MappingNameComboBoxField()
        {
            ComboBoxField comboBox = SetRequiredProperties();
            comboBox.MappingName = "comboBoxMapingName";
            return comboBox;
        }

        private ComboBoxField ToolTipComboBoxField()
        {
            ComboBoxField comboBox = SetRequiredProperties();
            comboBox.MappingName = "comboBoxMapingName";
            comboBox.ToolTip = "comboBoxToolTip";
            return comboBox;
        }
        private ComboBoxField ValuesComboBoxField()
        {
            ComboBoxField comboBox = SetRequiredProperties();
            comboBox.MappingName = "comboBoxMapingName";
            comboBox.ToolTip = "comboBoxToolTip";
            List<string> values = new List<string>() { "PDF", "XLS", "PPT", "DOC", "DOCX" };
            comboBox.Values = values;
            return comboBox;
        }
        private ComboBoxField SelectedIndexsComboBoxField()
        {
            ComboBoxField comboBox = SetRequiredProperties();
            comboBox.MappingName = "comboBoxMapingName";
            comboBox.ToolTip = "comboBoxToolTip";
            List<string> values = new List<string>() { "PDF", "XLS", "PPT", "DOC", "DOCX" };
            comboBox.Values = values;
            comboBox.SelectedIndexs = new List<int?>() { (int)1, (int)2 };
            return comboBox;
        }
        private ComboBoxField SetRequiredProperties()
        {
            List<ComboBoxFlagsEnum> ComboBoxFlags = new List<ComboBoxFlagsEnum>();
            ComboBoxFlags.Add(ComboBoxFlagsEnum.Edit);
            ComboBoxFlags.Add(ComboBoxFlagsEnum.CommitOnSelChange);

            RectangleF Bounds = new RectangleF(100, 250, 150, 25);
            string Name = "title";
            int PageIndex = 1;

            return new ComboBoxField(ComboBoxFlags, Bounds, Name, PageIndex);
        }


    }
}
