﻿using Spire.Cloud.Pdf.Sdk.Model;
using System.Collections.Generic;
using static Spire.Cloud.Pdf.Sdk.Model.CheckBoxField;

namespace Spire.Cloud.Pdf.Sdk.TestHelper
{
    internal class CheckBoxHelper
    {
        internal enum CheckBoxFieldTestType
        {
            Required,
            MappingName,
            ToolTip,
            Value,
        }
        public CheckBoxField GetCheckBoxField(CheckBoxFieldTestType testType)
        {
            switch (testType)
            {
                case CheckBoxFieldTestType.Required:
                    return SimpleCheckBoxField();

                case CheckBoxFieldTestType.MappingName:
                    return MappingNameCheckBoxField();

                case CheckBoxFieldTestType.ToolTip:
                    return ToolTipCheckBoxField();

                case CheckBoxFieldTestType.Value:
                    return ValuesCheckBoxField();
            }
            return null;
        }

        private CheckBoxField SimpleCheckBoxField()
        {
            CheckBoxField CheckBox = SetRequiredProperties();
            return CheckBox;
        }
        private CheckBoxField MappingNameCheckBoxField()
        {
            CheckBoxField CheckBox = SetRequiredProperties();
            CheckBox.MappingName = "CheckBoxMapingName";
            return CheckBox;
        }

        private CheckBoxField ToolTipCheckBoxField()
        {
            CheckBoxField CheckBox = SetRequiredProperties();
            CheckBox.MappingName = "CheckBoxMapingName";
            CheckBox.ToolTip = "CheckBoxToolTip";
            return CheckBox;
        }
        private CheckBoxField ValuesCheckBoxField()
        {
            CheckBoxField CheckBox = SetRequiredProperties();
            CheckBox.MappingName = "CheckBoxMapingName";
            CheckBox.ToolTip = "CheckBoxToolTip";
            CheckBox.Value = "true";
            return CheckBox;
        }
        private CheckBoxField SetRequiredProperties()
        {
            List<CheckBoxFlagsEnum> CheckBoxFlags = new List<CheckBoxFlagsEnum>();
            CheckBoxFlags.Add(CheckBoxFlagsEnum.NoExport);
            CheckBoxFlags.Add(CheckBoxFlagsEnum.Required);

            RectangleF Bounds = new RectangleF(300, 500, 20, 20);
            string Name = "agreement_of_terms";
            int PageIndex = 1;

            return new CheckBoxField(CheckBoxFlags, Bounds,Name, PageIndex);
        }
    }
}
