﻿using Newtonsoft.Json.Linq;
using Spire.Cloud.Pdf.Sdk.Api;
using Spire.Cloud.Pdf.Sdk.Client;
using System.IO;
using System;

namespace SpireCloudSDK
{
    class DocumentSearch_
    {
        static string appId_AI = "you ai id";
        static string appKey_AI = "you ai key";
        static string baseUrl_AI = "base url";
        static Configuration pdfConfiguration_AI = new Configuration(appId_AI, appKey_AI, baseUrl_AI);
        static PdfAIApi pdfAIApi = new PdfAIApi(pdfConfiguration_AI);

        public static void DocumentSearch()
        {
            string name = "孔乙己.pdf";
            string destFilePath = "output/DocSearch.txt";
            string question = "这篇文章讲了什么？ 请用中文回答：";
            string folder = "input";

            pdfAIApi.DocumentSearch(name, destFilePath, question, null, null, null, folder, null);
        }

        public static void DocumentSearch_EnableHistory()
        {
            string name = "孔乙己.pdf";
            string destFilePath = "output/DocumentSearch_EnableHistory.txt";
            string question = "这篇文章讲了什么？ 请用中文回答：";
            bool enableHistory = true;
            string folder = "input";

            pdfAIApi.DocumentSearch(name, destFilePath, question, enableHistory,null,null, folder, null);
        }
        public void DocumentSearch_EnableHistoryWithId()
        {
            string name = "孔乙己.pdf";
            string destFilePath = "output/DocumentSearch_EnableHistoryWithId.txt";
            string question = "我刚才的问题要求什么语言回答？";
            bool enableHistory = true;
            string conversationID = GetConversationID("output/DocumentSearch_EnableHistory.txt");
            string folder = "input";

            pdfAIApi.DocumentSearch(name, destFilePath, question, enableHistory, null, conversationID, folder, null);
        }
        public void DocumentSearch_UnableHistory()
        {
            string name = "孔乙己.pdf";
            string destFilePath = "output/DocumentSearch_EnableHistoryWithId.txt";
            string question = "这篇文章讲了什么？ 请用中文回答：";
            bool enableHistory = false;
            string folder = "input";

            pdfAIApi.DocumentSearch(name, destFilePath, question, enableHistory, null,null, folder, null);
        }
        public void DocumentSearch_UnableHistoryWithId()
        {
            string name = "孔乙己.pdf";
            string destFilePath = "output/DocumentSearch_UnableHistoryWithId.txt";
            string question = "我刚才问了什么问题？";
            bool enableHistory = false;
            string conversationID = GetConversationID("output/DocumentSearch_EnableHistory.txt");
            string folder = "input";

            pdfAIApi.DocumentSearch(name, destFilePath, question, enableHistory, null, conversationID, folder, null);
        }
        public void DocumentSearch_Encryption()
        {
            string name = "Encryption.pdf";
            string destFilePath = "output/DocumentSearch_Encryption.txt";
            string question = "这篇文章讲了什么？请用中文回答：";
            bool enableHistory = true;
            string conversationID = GetConversationID("output/DocumentSearch_EnableHistory.txt");
            string folder = "input";
            string password = "1234abcd";

            pdfAIApi.DocumentSearch(name, destFilePath, question, enableHistory, conversationID,password, folder, null);
        }
        static string GetConversationID(string filePath)
        {
            string lastLine = string.Empty;
            try
            {
                using (StreamReader reader = new StreamReader(filePath, System.Text.Encoding.UTF8))
                {
                    string line;
                    while ((line = reader.ReadLine()) != null)
                    {
                        lastLine = line;
                    }
                }
                if (!string.IsNullOrEmpty(lastLine))
                {
                    JObject jsonObject = JObject.Parse(lastLine);

                    string conversationId = (string)jsonObject["conversationID"];
                    return conversationId;
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine($"An error occurred: {ex.Message}");
            }
            return string.Empty;
        }
    }
}