﻿using Newtonsoft.Json.Linq;
using Spire.Cloud.Pdf.Sdk.Api;
using Spire.Cloud.Pdf.Sdk.Client;
using System.IO;
using System;

namespace SpireCloudSDK
{
    class Ask_
    {
        static string appId_AI = "you ai id";
        static string appKey_AI = "you ai key";
        static string baseUrl_AI = "base url";
        static Configuration pdfConfiguration_AI = new Configuration(appId_AI, appKey_AI, baseUrl_AI);
        static PdfAIApi pdfAIApi = new PdfAIApi(pdfConfiguration_AI);

        public void Ask()
        {
            string name = "Ask.txt";
            string folder = "input";
            string question = "写一首关于春天的五言绝句";

            pdfAIApi.Ask(name, question, null, null, folder, null);
        }

        public void Ask_EnableHistory()
        {
            string name = "output/Ask_EnableHistory.txt";
            string question = "推荐春天游玩的方式，请返回markdown格式";
            bool enableHistory = true;
            string folder = "input";

            pdfAIApi.Ask(name, question, enableHistory, null, folder, null);
        }
        public void Ask_EnableHistoryWithId()
        {
            string name = "output/Ask_EnableHistoryWithId.txt";
            string question = "我刚才问了关于春天的什么？";
            bool enableHistory = true;
            string folder = "input";
            string conversationID = GetConversationID("output/Ask_EnableHistory.txt");
            pdfAIApi.Ask(name, question, enableHistory, conversationID, folder, null);
        }
        public void Ask_UnableHistory()
        {
            string name = "output/Ask_UnableHistory.txt";
            string question = "推荐春天游玩的方式，请返回markdown格式？";
            bool enableHistory = false;
            string folder = "input";

            pdfAIApi.Ask(name, question, enableHistory, null, folder, null);
        }

        public void Ask_UnableHistoryWithId()
        {
            string name = "output/Ask_UnableHistoryWithId.txt";
            string question = "刚才问了什么？";
            bool enableHistory = false;
            string folder = "input";
            string conversationID = GetConversationID("output/Ask_EnableHistory.txt");

            pdfAIApi.Ask(name, question, enableHistory, conversationID, folder, null);
        }
        public void AskWithId()
        {
            string name = "output/AskWithId.txt";
            string question = "刚才问了什么？";
            string folder = "input";
            string conversationID = GetConversationID("output/AskWithId.txt");

            pdfAIApi.Ask(name, question, null, conversationID, folder, null);
        }

        static string GetConversationID(string filePath)
        {
            string lastLine = string.Empty;
            try
            {
                using (StreamReader reader = new StreamReader(filePath, System.Text.Encoding.UTF8))
                {
                    string line;
                    while ((line = reader.ReadLine()) != null)
                    {
                        lastLine = line;
                    }
                }
                if (!string.IsNullOrEmpty(lastLine))
                {
                    JObject jsonObject = JObject.Parse(lastLine);

                    string conversationId = (string)jsonObject["conversationID"];
                    return conversationId;
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine($"An error occurred: {ex.Message}");
            }
            return string.Empty;
        }
    }
}