using Spire.Cloud.Excel.Sdk.Client;
using Spire.Cloud.Excel.Sdk.Api;
using Newtonsoft.Json.Linq;
using System.IO;
using System;

namespace SpireCloudSDK
{
    public class Search_
    {
        static string appId_AI = "you ai id";
        static string appKey_AI = "you ai key";
        static string baseUrl_AI = "base url";
        static Configuration excelConfiguration_AI = new Configuration(appId_AI, appKey_AI, baseUrl_AI);
        static ExcelAIApi excelAIApi = new ExcelAIApi(excelConfiguration_AI);

        public static void Search()
        {
            string name = "Search.txt";
            string question = "㶹мд Ļش";
            string language = "chinese";
            string folder = "output";

            excelAIApi.Search(name, question, language, null, null, folder, null);
        }
        public static void Search_EnableHistory()
        {
            string name = "Search_True.txt";
            string question = "߾,о";
            string language = "chinese";
            bool enableHistory = true;
            string folder = "output";

            excelAIApi.Search(name, question, language, enableHistory, null, folder, null);
        }
        public static void Search_EnableHistoryWithId()
        {
            string name = "Search_EnableHistoryWithId.txt";
            string question = "Ҹոᵽʲô";
            string language = "chinese";
            bool enableHistory = true;
            string folder = "output";
            string conversationID = GetConversationID("output/DocumentSearch_EnableHistory.txt");

            excelAIApi.Search(name, question, language, enableHistory, conversationID, folder, null);
        }
        public static void Search_UnableHistory()
        {
            string name = "Search_UnableHistory.txt";
            string question = "how we can add a clickable URL to the Image as well?";
            string language = "Chinese";
            bool enableHistory = false;
            string folder = "output";

            excelAIApi.Search(name, question, language, enableHistory, null, folder, null);
        }
        public static void Search_UnableHistoryWithId()
        {
            string name = "Search_UnableHistoryWithId.txt";
            string question = "Ҹոᵽʲô";
            string language = "Chinese";
            bool enableHistory = false;
            string folder = "output";
            string conversationID = GetConversationID("output/DocumentSearch_EnableHistory.txt");

            excelAIApi.Search(name, question, language, enableHistory, conversationID, folder, null);
        }
        static string GetConversationID(string filePath)
        {
            string lastLine = string.Empty;
            try
            {
                using (StreamReader reader = new StreamReader(filePath, System.Text.Encoding.UTF8))
                {
                    string line;
                    while ((line = reader.ReadLine()) != null)
                    {
                        lastLine = line;
                    }
                }
                if (!string.IsNullOrEmpty(lastLine))
                {
                    JObject jsonObject = JObject.Parse(lastLine);

                    string conversationId = (string)jsonObject["conversationID"];
                    return conversationId;
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine($"An error occurred: {ex.Message}");
            }
            return string.Empty;
        }
    }
}
