import spire.cloud.word.sdk.ApiException;
import spire.cloud.word.sdk.Configuration;
import spire.cloud.word.sdk.api.WordAIApi;

public class Translate {
    public static String baseUrl =  "base url";
    public static String appId =  "your ai id";
    public static String appKey =  "your ai key";

    static Configuration wordConfiguration_AI = new Configuration(appId, appKey,baseUrl);
    static WordAIApi wordAIApi = new WordAIApi(wordConfiguration_AI);


    public static void translateDocument()
    {
        String name = "sample.docx";
        String folder = "input";
        String language = "Chinese";
        String destFilePath = "output/TranslateDocument.docx";

        try {
            wordAIApi.translateDocument(name, language, destFilePath, folder, null, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }
    public static void translateDocumentWithEncryption()
    {
        String name = "sample.docx";
        String folder = "input";
        String language = "Chinese";
        String password = "123456";
        String destFilePath = "output/TranslateDocumentWithEncryption.docx";

        try {
            wordAIApi.translateDocument(name, language, destFilePath, folder, null, password);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }
    public static void translateParagraph()
    {
        String name = "sample.docx";
        String folder = "input";
        String language = "Chinese";
        String destFilePath = "output/TranslateParagraph.docx";
        String paragraphPath = "Section/0/Paragraph/2";

        try {
            wordAIApi.translateParagraph(name,paragraphPath, language, destFilePath, folder, null, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public static void translateTextRange()
    {
        String name = "sample.docx";
        String folder = "input";
        String language = "Chinese";
        String destFilePath = "output/TranslateParagraph.docx";
        String paragraphPath = "Section/0/Paragraph/2";
        int indexOfRange = 0;

        try {
            wordAIApi.translateTextRange(name, paragraphPath, indexOfRange,language, destFilePath, folder, null, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }
}
