import spire.cloud.word.sdk.ApiException;
import spire.cloud.word.sdk.Configuration;
import spire.cloud.word.sdk.api.WordAIApi;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Dictionary;
import java.util.Hashtable;

public class SearchDocument {
    public static String baseUrl =  "base url";
    public static String appId =  "your ai id";
    public static String appKey =  "your ai key";

    static Configuration wordConfiguration_AI = new Configuration(appId, appKey,baseUrl);
    static WordAIApi wordAIApi = new WordAIApi(wordConfiguration_AI);

    public static void searchDocument()
    {
        String name = "sample.docx";
        String folder = "input";
        String question = "这篇文章讲了什么？ 请用中文回答：";
        boolean enableHistory = false;
        try {
            String response = wordAIApi.searchDocument(name,question,null,enableHistory,null,folder, null,null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }
    public static void searchDocumentEnableHistory()
    {
        String name = "sample.docx";
        String folder = "input";
        String question = "这篇文章讲了什么？ 请用中文回答：";
        boolean enableHistory = true;
        String response = null;
        try {
            response = wordAIApi.searchDocument(name,question,null,enableHistory,null,folder, null,null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }

        String destFilePath = "local_output/SearchDocument_EnableHistory.txt";

    }
    public static void searchDocumentEnableHistoryWidthId()
    {
        String name = "sample.docx";
        String folder = "input";
        String question = "我刚才的问题要求什么语言回答？";
        boolean enableHistory = true;
        String conversationID = getConversationID("local_output/SearchDocument_EnableHistory.txt");

        try {
            String response = wordAIApi.searchDocument(name,question,null,enableHistory,null,folder, null,null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }
    public static void searchDocumentUnableHistory()
    {
        String name = "sample.docx";
        String folder = "input";
        String question = "这篇文章讲了什么？ 请用中文回答：";
        boolean enableHistory = false;;

        try {
            String response = wordAIApi.searchDocument(name,question,null,enableHistory,null,folder, null,null);
        } catch (ApiException e) {
            try {
                throw new RuntimeException(e);
            } catch (RuntimeException ex) {


            }
        }
    }
    public static void searchDocumentUnableHistoryWithId()
    {
        String name = "sample.docx";
        String folder = "input";
        String question = "我刚才问了什么问题？";
        boolean enableHistory = false;
        String conversationID = getConversationID("amy_output/SearchDocument_EnableHistory.txt");

        try {
            String response = wordAIApi.searchDocument(name,question,null,enableHistory,null,folder, null,null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }


    public static void searchDocumentOptions()
    {
        String name = "sample.docx";
        String folder = "input";
        String question = "这篇文章讲了什么？ 请用中文回答：";
        String password = "1234abcd";
        boolean enableHistory = false;
        Dictionary<String, String> options = new Hashtable<String, String>();
        options.put("search_type", "similarity");
        options.put("search_kwargs", "{\"k\": 10}");

        try {
            String response = wordAIApi.searchDocument(name,question,null,enableHistory,null,folder, null,null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }
    public static String getConversationID(String filename) {

        String file = java.nio.file.Paths.get(filename).toString();
        // 读取文件的最后一行
        String lastLine =null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream, StandardCharsets.UTF_8);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);

            String line;
            while ((line = bufferedReader.readLine()) != null) {
                lastLine = line;
            }
            if (!lastLine.isEmpty())
            {
                String[] parts = lastLine.split(":");
                if (parts.length>00)
                {
                    // 移除ID字符串中的空格
                    String id = parts[parts.length - 1].trim();
                    return id;
                }
            }
            bufferedReader.close();
        }
        catch (Exception ex)
        {
            System.out.print("An error occurred:"+ ex.getMessage());
        }
        return null;
    }
}
