package org.example.WordDemo;

import spire.cloud.word.sdk.ApiException;
import spire.cloud.word.sdk.Configuration;
import spire.cloud.word.sdk.api.WordAIApi;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;

public class Search {
    public static String baseUrl = "base url";
    public static String appId = "your ai id";
    public static String appKey = "your ai key";
    static Configuration wordConfiguration_AI = new Configuration(appId, appKey, baseUrl);
    static WordAIApi wordAIApi = new WordAIApi(wordConfiguration_AI);

    public static void search() {
        String question = "Write a song about winter";
        String language = "English";
        try {
            String response = wordAIApi.search(question, language, false, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public static void searchEnableHistory() {
        String question = "How many days are there in a year?";
        boolean enableHistory = true;
        String language = "English";
        try {
            String response = wordAIApi.search(question, language, enableHistory, null);
            String destFilePath = "Search_EnableHistory.txt";
            Files.write(Paths.get(destFilePath), response.getBytes());
        } catch (ApiException | IOException e) {
            throw new RuntimeException(e);
        }


    }

    public static void searchEnableHistoryWidthId() {
        String question = "What question did I ask?";
        boolean enableHistory = true;
        String language = "English";
        String conversationID = getConversationID("Search_EnableHistory.txt");
        try {
            String response = wordAIApi.search(question, language, enableHistory, conversationID);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public static void searchUnableHistory() {
        String question = "To recommend the way to play in spring, please return to markdown format";
        boolean enableHistory = false;
        String language = "English";
        try {
            String response = wordAIApi.search(question, language, enableHistory, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public static void searchUnableHistoryWidthId() {
        String question = "What question did I ask?";
        boolean enableHistory = false;
        String language = "English";
        String conversationID = getConversationID("Search_EnableHistory.txt");
        try {
            String response = wordAIApi.search(question, language, enableHistory, conversationID);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getConversationID(String filename) {

        String file = java.nio.file.Paths.get(filename).toString();
        // 读取文件的最后一行
        String lastLine = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream, StandardCharsets.UTF_8);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);

            String line;
            while ((line = bufferedReader.readLine()) != null) {
                lastLine = line;
            }
            if (!lastLine.isEmpty()) {
                String[] parts = lastLine.split(":");
                if (parts.length > 00) {
                    // 移除ID字符串中的空格
                    String id = parts[parts.length - 1].trim();
                    return id;
                }
            }
            bufferedReader.close();
        } catch (Exception ex) {
            System.out.print("An error occurred:" + ex.getMessage());
        }
        return null;
    }
}
