import spire.cloud.word.sdk.ApiException;
import spire.cloud.word.sdk.Configuration;
import spire.cloud.word.sdk.api.WordAIApi;

public class RecognizeEntity {
    public static String baseUrl = "base url";
    public static String appId = "your ai id";
    public static String appKey = "your ai key";
    static Configuration wordConfiguration_AI = new Configuration(appId, appKey, baseUrl);
    static WordAIApi wordAIApi = new WordAIApi(wordConfiguration_AI);

    public static void recognizeDocumentEntities() {
        String name = "sample.docx";
        String folder = "input";
        String destFilePath = "output/RecognizeDocumentEntities.docx";
        String language = "English";

        try {
            wordAIApi.recognizeDocumentEntities(name, destFilePath, language, null, folder, null, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public static void recognizeDocumentEntitiesClassifications() {
        String name = "sample.docx";
        String folder = "input";
        String destFilePath = "output/RecognizeDocumentEntities_classifications.docx";
        String language = "English";
        String[] classifications = new String[]{"City", "Food"};

        try {
            wordAIApi.recognizeDocumentEntities(name, destFilePath, language, classifications, folder, null, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public static void recognizeEntityDocumentEncryption() {
        String name = "sample.docx";
        String folder = "input";
        String destFilePath = "output/RecognizeEntityDocument_Encryption.docx";
        String language = "English";
        String password = "123456";

        try {
            wordAIApi.recognizeDocumentEntities(name, destFilePath, language, null, folder, null, password);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public static void recognizeEntityParagraph() {
        String name = "sample.docx";
        String folder = "input";
        String destFilePath = "output/RecognizeEntityParagraph.docx";
        String language = "English";
        String paragraphPath = "Section/0/Paragraph/2";

        try {
            wordAIApi.recognizeParagraphEntities(name, paragraphPath, destFilePath, language, null, folder, null, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public static void recognizeEntityTextRange() {
        String name = "sample.docx";
        String folder = "input";
        String destFilePath = "output/RecognizeEntityTextRange.docx";
        String language = "English";
        String paragraphPath = "Section/0/Paragraph/2";
        int indexOfRange = 0;

        try {
            wordAIApi.recognizeTextRangeEntities(name, paragraphPath, indexOfRange, destFilePath, language, null, folder, null, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }
}
