import spire.cloud.word.sdk.ApiException;
import spire.cloud.word.sdk.Configuration;
import spire.cloud.word.sdk.api.WordAIApi;

public class Polish {
    public static String baseUrl = "base url";
    public static String appId = "your ai id";
    public static String appKey = "your ai key";
    static Configuration wordConfiguration_AI = new Configuration(appId, appKey, baseUrl);
    static WordAIApi wordAIApi = new WordAIApi(wordConfiguration_AI);

    public static void polishDocument() {
        String name = "sample.docx";
        String folder = "input";
        String destFilePath = "output/PolishDocument.docx";
        try {
            wordAIApi.polishDocument(name, destFilePath, null, folder, null, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public static void polishDocumentEncryption() {
        String name = "sample.docx";
        String folder = "input";
        String destFilePath = "output/PolishDocument_Encryption.docx";
        String password = "1234abcd";
        try {
            wordAIApi.polishDocument(name, destFilePath, null, folder, null, password);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public static void polishDocumentLanguage() {
        String name = "sample.docx";
        String folder = "input";
        String language = "English";
        String destFilePath = "output/PolishDocument_language.docx";

        try {
            wordAIApi.polishDocument(name, destFilePath, language, folder, null, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public static void polishParagraph() {
        String name = "sample.docx";
        String folder = "input";
        String paragraphPath = "Section/0/Paragraph/2";
        String destFilePath = "output/PolishParagraph.docx";

        try {
            wordAIApi.polishParagraph(name, paragraphPath, destFilePath, null, folder, null, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public static void polishTextRange() {
        String name = "sample.docx";
        String folder = "input";
        String paragraphPath = "Section/0/Paragraph/2";
        int indexOfRange = 0;
        String destFilePath = "output/PolishTextRange.docx";

        try {
            wordAIApi.polishTextRange(name, paragraphPath, indexOfRange, destFilePath, null, folder, null, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

}
