import spire.cloud.word.sdk.ApiException;
import spire.cloud.word.sdk.Configuration;
import spire.cloud.word.sdk.api.WordAIApi;

public class GenerateSummary {
    public static String baseUrl = "base url";
    public static String appId = "your ai id";
    public static String appKey = "your ai key";

    static Configuration wordConfiguration_AI = new Configuration(appId, appKey, baseUrl);
    static WordAIApi wordAIApi = new WordAIApi(wordConfiguration_AI);

    public static void generateSummaryDocument() {
        String name = "sample.docx";
        String folder = "input";
        String destFilePath = "output/GenerateSummaryDocument.docx";
        try {
            wordAIApi.generateDocumentSummary(name, destFilePath, null, folder, null, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public static void generateSummaryParagraph() {
        String name = "sample.docx";
        String folder = "input";
        String paragraphPath = "Section/0/Paragraph/2";
        String destFilePath = "output/GenerateSummaryParagraph.docx";
        try {
            wordAIApi.generateParagraphSummary(name, paragraphPath, destFilePath, null, folder, null, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public static void generateSummaryTextRange() {
        String name = "sample.docx";
        String folder = "input";
        String paragraphPath = "Section/0/Paragraph/2";
        String destFilePath = "output/GenerateSummaryTextRange.docx";
        int indexOfRange = 0;
        try {
            wordAIApi.generateTextRangeSummary(name, paragraphPath, indexOfRange, destFilePath, null, folder, null, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

}
