import spire.cloud.word.sdk.ApiException;
import spire.cloud.word.sdk.Configuration;
import spire.cloud.word.sdk.api.WordAIApi;

public class GenerateImage {
    public static String baseUrl = "base url";
    public static String appId = "your ai id";
    public static String appKey = "your ai key";

    static Configuration wordConfiguration_AI = new Configuration(appId, appKey, baseUrl);
    static WordAIApi wordAIApi = new WordAIApi(wordConfiguration_AI);

    public static void generateImage512() {
        String description = "美丽幽静的山谷中开满鲜花";
        WordAIApi.ImageModel model = WordAIApi.ImageModel.STABLE_DIFFUSION_512_V2_1;
        WordAIApi.ImageSize size = WordAIApi.ImageSize.I512x512;
        String destFilePath = "output/GenerateImage_512.png";

        try {
            wordAIApi.generateImage(description, model, size, destFilePath, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public static void generateImage1024() {
        String description = "美丽幽静的山谷中开满鲜花";
        WordAIApi.ImageModel model = WordAIApi.ImageModel.STABLE_DIFFUSION_XL_1024_V1_0;
        WordAIApi.ImageSize size = WordAIApi.ImageSize.I1024x1024;
        String destFilePath = "output/GenerateImage_1024.png";

        try {
            wordAIApi.generateImage(description, model, size, destFilePath, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }
}
