import spire.cloud.word.sdk.ApiException;
import spire.cloud.word.sdk.Configuration;
import spire.cloud.word.sdk.api.WordAIApi;

public class GenerateDocument {
    public static String baseUrl = "base url";
    public static String appId = "your ai id";
    public static String appKey = "your ai key";

    static Configuration wordConfiguration_AI = new Configuration(appId, appKey, baseUrl);
    static WordAIApi wordAIApi = new WordAIApi(wordConfiguration_AI);

    public static void generateDocument() {
        String topic = "Introduction to Chinese history";
        int wordsCount = 1000;
        String language = "English";
        String destFilePath = "output/GenerateDocument.docx";
        try {
            wordAIApi.generateDocument(topic, wordsCount, language, destFilePath, null, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public static void generateDocumentFormatted() {
        String topic = "介绍中国历史";
        int wordsCount = 500;
        String language = "Chinese";
        String[] formatRequirements = new String[]{"标题使用粗体 3号", "每一章小标题使用粗体 字体颜色蓝色"};
        String destFilePath = "output/GenerateDocument_Formatted.docx";
        try {
            wordAIApi.generateDocument(topic, wordsCount, language, destFilePath, formatRequirements, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }
}
