import spire.cloud.word.sdk.ApiException;
import spire.cloud.word.sdk.Configuration;
import spire.cloud.word.sdk.api.WordAIApi;

public class GenerateAbstract {
    public static String baseUrl =  "base url";
    public static String appId =  "your ai id";
    public static String appKey =  "your ai key";

    static Configuration wordConfiguration_AI = new Configuration(appId, appKey,baseUrl);
    static WordAIApi wordAIApi = new WordAIApi(wordConfiguration_AI);

    public static void generateAbstractDocument()
    {
        String name = "sample.docx";
        String folder = "input";
        String destFilePath = "output/GenerateAbstractDocument.docx";
        try {
            wordAIApi.generateDocumentAbstract(name, destFilePath, null, folder, null, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public static void generateAbstractParagraph()
    {
        String name = "sample.docx";
        String folder = "input";
        String destFilePath = "output/GenerateAbstractParagraph.docx";
        String paragraphPath = "Section/0/Paragraph/0";
        try {
            wordAIApi.generateParagraphAbstract(name, paragraphPath, destFilePath, null, folder, null, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public static void generateAbstractTextRange()
    {
        String name = "sample.docx";
        String folder = "input";
        String destFilePath = "output/GenerateAbstractTextRange.docx";
        String paragraphPath = "Section/0/Paragraph/0";
        int indexOfRange = 0;
        try {
            wordAIApi.generateTextRangeAbstract(name, paragraphPath, indexOfRange, destFilePath, null, folder, null, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }
}
