import spire.cloud.word.sdk.ApiException;
import spire.cloud.word.sdk.Configuration;
import spire.cloud.word.sdk.api.WordAIApi;

public class ContinueWriting {
    public static String baseUrl =  "base url";
    public static String appId =  "your ai id";
    public static String appKey =  "your ai key";

    static Configuration wordConfiguration_AI = new Configuration(appId, appKey,baseUrl);
    static WordAIApi wordAIApi = new WordAIApi(wordConfiguration_AI);

    public static void continueWritingDocument()
    {
        String name = "sample.docx";
        String folder = "input";
        String destFilePath = "output/ContinueWritingDocument.docx";
        String language = "English";
        String topic = "Introduce the historical site of China";
        try {
            wordAIApi.continueWritingDocument(name, topic, language, destFilePath, null, folder, null, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }

    }

    public static void continueWritingParagraph()
    {
        String name = "sample.docx";
        String folder = "input";
        String destFilePath = "output/ContinueWritingParagraph.docx";
        String language = "English";
        String topic = "Introduce the historical site of China";
        String paragraphPath = "Section/0/Paragraph/0";

        try {
            wordAIApi.continueWritingParagraph(name, paragraphPath, topic, language, destFilePath, null, folder, null, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public static void continueWritingTextRange()
    {
        String name = "sample.docx";
        String folder = "input";
        String destFilePath = "output/ContinueWritingTextRange.docx";
        String language = "English";
        String topic = "Introduce the historical site of China";
        String paragraphPath = "Section/0/Paragraph/0";
        int indexOfRange = 0;
        try {
            wordAIApi.continueWritingTextRange(name, paragraphPath, indexOfRange,topic, language, destFilePath, null, folder, null, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }
}
