import spire.cloud.word.sdk.ApiException;
import spire.cloud.word.sdk.Configuration;
import spire.cloud.word.sdk.api.WordAIApi;

public class CheckSpelling {
    public static String baseUrl =  "base url";
    public static String appId =  "your ai id";
    public static String appKey =  "your ai key";

    static Configuration wordConfiguration_AI = new Configuration(appId, appKey,baseUrl);
    static WordAIApi wordAIApi = new WordAIApi(wordConfiguration_AI);

    public static void checkSpellingDocument()
    {
        String name = "sample.docx";
        String folder = "input";
        String destFilePath = "output/CheckSpellingDocument.docx";
        String language = "English";
        try {
            wordAIApi.checkDocumentSpelling(name, destFilePath, language, folder, null, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }
    public static void checkSpellingParagraph()
    {
        String name = "sample.docx";
        String folder = "input";
        String destFilePath = "output/CheckSpellingParagraph.docx";
        String language = "English";
        String paragraphPath = "Section/0/Paragraph/0";
        try {
            wordAIApi.checkParagraphSpelling(name, paragraphPath, destFilePath, language, folder, null, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public static void checkSpellingTextRange()
    {
        String name = "sample.docx";
        String folder = "input";
        String destFilePath = "output/CheckSpellingTextRange.docx";
        String language = "English";
        String paragraphPath = "Section/0/Paragraph/0";
        int indexOfRange = 0;
        try {
            wordAIApi.checkTextRangeSpelling(name, paragraphPath, indexOfRange, destFilePath, language, folder, null, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

}
