import spire.cloud.word.sdk.ApiException;
import spire.cloud.word.sdk.Configuration;
import spire.cloud.word.sdk.api.WordAIApi;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;


public class Ask {

    public static String baseUrl = "base url";
    public static String appId = "your ai id";
    public static String appKey = "your ai key";

    static Configuration wordConfiguration_AI = new Configuration(appId, appKey, baseUrl);
    static WordAIApi wordAIApi = new WordAIApi(wordConfiguration_AI);

    public static void askEnableHistory() {
        String question = "一年有多少天？";
        boolean enableHistory = true;
        try {
            String response = wordAIApi.askQuestion(question, enableHistory, null);
            Files.write(Paths.get("Ask_UnableHistory.txt"), response.getBytes());
        } catch (ApiException | IOException e) {
            throw new RuntimeException(e);
        }
    }


    public static void askEnableHistoryWidthId() {
        String question = "我刚才问了什么问?";
        boolean enableHistory = true;
        String conversationID = getConversationID("Ask_EnableHistory.txt");
        try {
            String response = wordAIApi.askQuestion(question, enableHistory, conversationID);
            Files.write(Paths.get("Ask_EnableHistoryWidthId.txt"), response.getBytes());
        } catch (ApiException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void askUnableHistory() {
        String question = "推荐春天游玩的方式，请返回markdown格式";
        boolean enableHistory = false;
        try {
            String response = wordAIApi.askQuestion(question, enableHistory, null);
            Files.write(Paths.get("Ask_UnableHistory.txt"), response.getBytes());
        } catch (ApiException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void askUnableHistoryWidthId() {
        String question = "刚才问了什么?";
        boolean enableHistory = false;
        try {
            String conversationID = getConversationID("Ask_UnableHistory.txt");
            String response = wordAIApi.askQuestion(question, enableHistory, conversationID);
            Files.write(Paths.get("Ask_UnableHistoryWidthId.txt"), response.getBytes());
        } catch (ApiException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getConversationID(String filename) {

        String file = java.nio.file.Paths.get(filename).toString();
        // 读取文件的最后一行
        String lastLine = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream, StandardCharsets.UTF_8);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);

            String line;
            while ((line = bufferedReader.readLine()) != null) {
                lastLine = line;
            }
            if (!lastLine.isEmpty()) {
                String[] parts = lastLine.split(":");
                if (parts.length > 00) {
                    // 移除ID字符串中的空格
                    String id = parts[parts.length - 1].trim();
                    return id;
                }
            }
            bufferedReader.close();
        } catch (Exception ex) {
            System.out.print("An error occurred:" + ex.getMessage());
        }
        return null;
    }
}
