import spire.cloud.storage.sdk.Configuration;
import spire.cloud.storage.sdk.api.FileApi;
import java.io.File;

public class FileApiDemo {
    static String appId = "your id";
    static String appKey = "your key";
    static String baseUrl = "https://api.e-iceblue.cn";
    static Configuration configuration = new Configuration(appId, appKey, baseUrl);
    static FileApi fileApi = new FileApi(configuration);
    public static void copyFile() throws Exception{
        String srcPath = "input/test.docx";
        String destPath = "input/test/test2.docx";
        String srcStorageName = null;
        String destStorageName = null;
        fileApi.copyFile(srcPath, destPath, srcStorageName, destStorageName);
    }
    public static void deleteFile() throws Exception{
        String path = "input/test.docx"; ;
        String storageName = null;
        fileApi.deleteFile(path, storageName);
    }
    public static void downloadFile() throws Exception{
        String path = "input/test.pptx";
        String storageName = null;
        File response = fileApi.downloadFile(path, storageName);
    }
    public static void moveFile() throws Exception{
        String srcPath = "input/test.pptx";
        String destPath = "output/test/test.pptx";
        String srcStorageName = null;
        String destStorageName = null;
        fileApi.moveFile(srcPath, destPath, srcStorageName, destStorageName);
    }
    public static void uploadFile() throws Exception{
        String path = "input/new.pptx";
        String localFilePath = "D:/input/test3.pptx";
        File data = new File(localFilePath);
        String storageName = null;
        fileApi.uploadFile(path, data, storageName);
    }
    public static void getSignatureUrl() throws Exception{
        String path = "input/new.pptx";
        String storageName = null;
        java.math.BigDecimal expiration = new java.math.BigDecimal(10000);
        fileApi.signatureUrl(path, expiration, storageName);
    }
}
