import spire.cloud.pdf.sdk.ApiException;
import spire.cloud.pdf.sdk.Configuration;
import spire.cloud.pdf.sdk.api.PdfAIApi;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class Search {
    public static String baseUrl =  "base url";
    public static String appId =  "your ai id";
    public static String appKey =  "your ai key";


    static Configuration pdfConfiguration_AI = new Configuration(appId, appKey,baseUrl);
    static PdfAIApi pdfAIApi = new PdfAIApi(pdfConfiguration_AI);


    public static void searchEnableHistory()
    {
        String name = "search_EnableHistory.txt";
        String language = "chinese";
        String question = "如何提高居民消费欲望,请列举三点";
        String folder = "output";
        boolean enableHistory = true;

        try {
            pdfAIApi.search(name,question,language,enableHistory,null,folder,null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }
    public static void searchEnableHistoryWithId()
    {
        String name = "search_EnableHistoryWithId.txt";
        String question = "我刚刚提到了什么？";
        String language = "English";
        boolean enableHistory = true;
        String folder = "output";
        String conversationID = getConversationID("output/search_EnableHistory.txt");

        try {
            pdfAIApi.search(name,question,language,enableHistory,conversationID,folder,null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }
    public static void searchUnableHistory()
    {
        String name = "search_UnableHistory.txt";
        String question = "how we can add a clickable URL to the Image as well?";
        String language = "Chinese";
        String folder = "output";
        boolean enableHistory = false;

        try {
            pdfAIApi.search(name,question,language,enableHistory,null,folder,null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }
    public static void searchUnableHistoryWithId()
    {
        String name = "search_UnableHistoryWithId.txt";
        String question = "我刚刚提到了什么？";
        String language = "Chinese";
        String folder = "output";
        boolean enableHistory = false;
        String conversationID = getConversationID("output/search_EnableHistory.txt");

        try {
            pdfAIApi.search(name, question, language, enableHistory, conversationID, folder, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }
    public static String getConversationID(String filename) {

        String file = java.nio.file.Paths.get(filename).toString();
        // 读取文件的最后一行
        String lastLine =null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream, StandardCharsets.UTF_8);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);

            String line;
            while ((line = bufferedReader.readLine()) != null) {
                lastLine = line;
            }
            if (!lastLine.isEmpty())
            {
                String[] parts = lastLine.split(":");
                if (parts.length>00)
                {
                    // 移除ID字符串中的空格
                    String id = parts[parts.length - 1].trim();
                    return id;
                }
            }
            bufferedReader.close();
        }
        catch (Exception ex)
        {
            System.out.print("An error occurred:"+ ex.getMessage());
        }
        return null;
    }
}
