import spire.cloud.pdf.sdk.ApiException;
import spire.cloud.pdf.sdk.Configuration;
import spire.cloud.pdf.sdk.api.PdfAIApi;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class DocumentSearch {
    public static String baseUrl = "base url";
    public static String appId = "your ai id";
    public static String appKey = "your ai key";


    static Configuration pdfConfiguration_AI = new Configuration(appId, appKey, baseUrl);
    static PdfAIApi pdfAIApi = new PdfAIApi(pdfConfiguration_AI);

    public static void documentSearchEnableHistory() {
        String name = "孔乙己.pdf";
        String destFilePath = "output/DocumentSearch_EnableHistory.txt";
        String question = "这篇文章讲了什么？ 请用中文回答：";
        boolean enableHistory = true;
        String folder = "input";

        try {
            pdfAIApi.documentSearch(name, destFilePath, question, enableHistory, null, null, folder, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public void documentSearchEnableHistoryWithId() {
        String name = "孔乙己.pdf";
        String destFilePath = "output/DocumentSearch_EnableHistoryWithId.txt";
        String question = "我刚才的问题要求什么语言回答？";
        boolean enableHistory = true;
        String conversationID = getConversationID("output/DocumentSearch_EnableHistory.txt");
        String folder = "input";

        try {
            pdfAIApi.documentSearch(name, destFilePath, question, enableHistory, conversationID, null, folder, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public void documentSearchUnableHistory() {
        String name = "孔乙己.pdf";
        String destFilePath = "output/DocumentSearch_EnableHistoryWithId.txt";
        String question = "这篇文章讲了什么？ 请用中文回答：";
        boolean enableHistory = false;
        String folder = "input";

        try {
            pdfAIApi.documentSearch(name, destFilePath, question, enableHistory, null, null, folder, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public void documentSearchUnableHistoryWithId() {
        String name = "孔乙己.pdf";
        String destFilePath = "output/DocumentSearch_UnableHistoryWithId.txt";
        String question = "我刚才问了什么问题？";
        boolean enableHistory = false;
        String conversationID = getConversationID("output/DocumentSearch_EnableHistory.txt");
        String folder = "input";

        try {
            pdfAIApi.documentSearch(name, destFilePath, question, enableHistory, conversationID, null, folder, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public void documentSearchEncryption() {
        String name = "Encryption.pdf";
        String destFilePath = "output/DocumentSearch_Encryption.txt";
        String question = "这篇文章讲了什么？请用中文回答：";
        boolean enableHistory = true;
        String conversationID = getConversationID("output/DocumentSearch_EnableHistory.txt");
        String folder = "input";
        String password = "123456";

        try {
            pdfAIApi.documentSearch(name, destFilePath, question, enableHistory, conversationID, password, folder, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getConversationID(String filename) {

        String file = java.nio.file.Paths.get(filename).toString();

        String lastLine = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream, StandardCharsets.UTF_8);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);

            String line;
            while ((line = bufferedReader.readLine()) != null) {
                lastLine = line;
            }
            if (!lastLine.isEmpty()) {
                String[] parts = lastLine.split(":");
                if (parts.length > 00) {
                    String id = parts[parts.length - 1].trim();
                    return id;
                }
            }
            bufferedReader.close();
        } catch (Exception ex) {
            System.out.print("An error occurred:" + ex.getMessage());
        }
        return null;
    }
}
