import spire.cloud.pdf.sdk.ApiException;
import spire.cloud.pdf.sdk.Configuration;
import spire.cloud.pdf.sdk.api.PdfAIApi;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class ASK {
    public static String baseUrl = "base url";
    public static String appId = "your ai id";
    public static String appKey = "your ai key";


    static Configuration pdfConfiguration_AI = new Configuration(appId, appKey, baseUrl);
    static PdfAIApi pdfAIApi = new PdfAIApi(pdfConfiguration_AI);


    public void askEnableHistory() {
        String name = "output/Ask_EnableHistory.txt";
        String question = "推荐春天游玩的方式，请返回markdown格式";
        boolean enableHistory = true;
        String folder = "input";

        try {
            pdfAIApi.ask(name, question, enableHistory, null, folder, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public void akEnableHistoryWithId() {
        String name = "output/Ask_EnableHistoryWithId.txt";
        String question = "我刚才问了关于春天的什么？";
        boolean enableHistory = true;
        String folder = "input";
        String conversationID = getConversationID("output/Ask_EnableHistory.txt");
        try {
            pdfAIApi.ask(name, question, enableHistory, conversationID, folder, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public void askUnableHistory() {
        String name = "output/Ask_UnableHistory.txt";
        String question = "推荐春天游玩的方式，请返回markdown格式？";
        boolean enableHistory = false;
        String folder = "input";

        try {
            pdfAIApi.ask(name, question, enableHistory, null, folder, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public void askUnableHistoryWithId() {
        String name = "output/Ask_UnableHistoryWithId.txt";
        String question = "刚才问了什么？";
        boolean enableHistory = false;
        String folder = "input";
        String conversationID = getConversationID("output/Ask_EnableHistory.txt");

        try {
            pdfAIApi.ask(name, question, enableHistory, conversationID, folder, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getConversationID(String filename) {

        String file = java.nio.file.Paths.get(filename).toString();
        // 读取文件的最后一行
        String lastLine = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream, StandardCharsets.UTF_8);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);

            String line;
            while ((line = bufferedReader.readLine()) != null) {
                lastLine = line;
            }
            if (!lastLine.isEmpty()) {
                String[] parts = lastLine.split(":");
                if (parts.length > 00) {
                    // 移除ID字符串中的空格
                    String id = parts[parts.length - 1].trim();
                    return id;
                }
            }
            bufferedReader.close();
        } catch (Exception ex) {
            System.out.print("An error occurred:" + ex.getMessage());
        }
        return null;
    }
}
