import spire.cloud.powerpoint.sdk.ApiException;
import spire.cloud.powerpoint.sdk.Configuration;
import spire.cloud.powerpoint.sdk.api.PowerPointAIApi;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class Search {
    public static String baseUrl =  "base url";
    public static String appId =  "your ai id";
    public static String appKey =  "your ai key";


    static Configuration pptConfiguration_AI = new Configuration(appId, appKey,baseUrl);
    static PowerPointAIApi pptAIApi = new PowerPointAIApi(pptConfiguration_AI);


    public static void searchEnableHistory()
    {
        String fileName = "Search_EnableHistory.txt";
        String question = "how we can add a clickable URL to the Image as well?";
        String language = "Chinese";
        boolean enableHistory = true;
        String folder = "output";
        try {
            pptAIApi.search(fileName, question, language, enableHistory, null, folder, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }
    public static void searchEnableHistoryWithId()
    {
        String fileName = "Search_EnableHistoryWithId.txt";
        String question = "我刚刚提到了什么？";
        String language = "Chinese";
        boolean enableHistory = true;
        String conversationID = getConversationID("output/Search_EnableHistory.txt");
        String folder = "input";
        try {
            pptAIApi.search(fileName, question, language, enableHistory, conversationID, folder, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }
    public static void searchUnableHistory()
    {
        String fileName = "Search_UnableHistory.txt";
        String question = "how we can add a clickable URL to the Image as well?";
        String language = "English";
        boolean enableHistory = false;
        String folder = "output";
        try {
            pptAIApi.search(fileName, question, language, enableHistory, null, folder, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }
    public void Search_UnableHistoryWithId()
    {
        String fileName = "Search_UnableHistoryWithId.txt";
        String question = "我刚刚提到了什么？";
        String language = "English";
        boolean enableHistory = false;
        String conversationID = getConversationID("output/Search_EnableHistory.txt");
        String folder = "output";
        try {
            pptAIApi.search(fileName, question, language, enableHistory, conversationID, folder, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getConversationID(String filename) {

        String file = java.nio.file.Paths.get(filename).toString();
        // 读取文件的最后一行
        String lastLine =null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream, StandardCharsets.UTF_8);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);

            String line;
            while ((line = bufferedReader.readLine()) != null) {
                lastLine = line;
            }
            if (!lastLine.isEmpty())
            {
                String[] parts = lastLine.split(":");
                if (parts.length>00)
                {
                    // 移除ID字符串中的空格
                    String id = parts[parts.length - 1].trim();
                    return id;
                }
            }
            bufferedReader.close();
        }
        catch (Exception ex)
        {
            System.out.print("An error occurred:"+ ex.getMessage());
        }
        return null;
    }
}
