import spire.cloud.powerpoint.sdk.ApiException;
import spire.cloud.powerpoint.sdk.Configuration;
import spire.cloud.powerpoint.sdk.api.PowerPointAIApi;

public class ImageGenerate {
    public static String baseUrl = "base url";
    public static String appId = "your ai id";
    public static String appKey = "your ai key";


    static Configuration pptConfiguration_AI = new Configuration(appId, appKey, baseUrl);
    static PowerPointAIApi pptAIApi = new PowerPointAIApi(pptConfiguration_AI);

    public static void imageGenerate_I512x512() {
        String fileName = "ImageGenerate_I512x512.png";
        String description = "美丽幽静的山谷中开满鲜花";
        String folder = "output";
        String model = "STABLE_DIFFUSION_512_V2_1";
        String size = "I512x512";

        try {
            pptAIApi.imageGenerate(fileName, description, model, size, folder, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public static void ImageGenerate_I1024x1024() {
        String fileName = "ImageGenerate_I1024x1024.png";
        String description = "美丽幽静的山谷中开满鲜花";
        String folder = "output";
        String model = "STABLE_DIFFUSION_XL_1024_V1_0";
        String size = "I1024x1024";

        try {
            pptAIApi.imageGenerate(fileName, description, model, size, folder, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

}
