import spire.cloud.powerpoint.sdk.ApiException;
import spire.cloud.powerpoint.sdk.Configuration;
import spire.cloud.powerpoint.sdk.api.PowerPointAIApi;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class Ask {
    public static String baseUrl =  "base url";
    public static String appId =  "your ai id";
    public static String appKey =  "your ai key";


    static Configuration pptConfiguration_AI = new Configuration(appId, appKey,baseUrl);
    static PowerPointAIApi pptAIApi = new PowerPointAIApi(pptConfiguration_AI);

    public static void askEnableHistory()
    {
        String fileName = "Ask_EnableHistory.txt";
        String question = "推荐春天游玩的方式，请返回markdown格式";
        boolean enableHistory = true;
        String folder = "output";
        String conversationID = null;
        String storage = null;
        try {
            pptAIApi.ask(fileName, question, enableHistory, conversationID, folder, storage);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }
    public static void askEnableHistoryWidthId()
    {
        String fileName = "Ask_EnableHistoryWidthId.txt";
        String question = "推荐春天游玩的方式，请返回markdown格式";
        boolean enableHistory = true;
        String conversationID = getConversationID("output/Ask_EnableHistory.txt");
        String folder = "output";
        String storage = null;
        try {
            pptAIApi.ask(fileName, question, enableHistory, conversationID, folder, storage);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }
    public static void askUnableHistory()
    {
        String fileName = "Ask_UnableHistory.txt";
        String question = "推荐春天游玩的方式，请返回markdown格式";
        boolean enableHistory = false;
        String conversationID = null;
        String folder = "output";
        String storage = null;
        try {
            pptAIApi.ask(fileName, question, enableHistory, conversationID, folder, storage);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }
    public static void askUnableHistoryWithId()
    {
        String fileName = "Ask_UnableHistoryWithId.txt";
        String question = "刚才问了什么？";
        boolean enableHistory = false;
        String conversationID = getConversationID("output/Ask_EnableHistory.txt");
        String folder = "output";
        String storage = null;
        try {
            pptAIApi.ask(fileName, question, enableHistory, conversationID, folder, storage);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }
    public static String getConversationID(String filename) {

        String file = java.nio.file.Paths.get(filename).toString();
        // 读取文件的最后一行
        String lastLine =null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream, StandardCharsets.UTF_8);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);

            String line;
            while ((line = bufferedReader.readLine()) != null) {
                lastLine = line;
            }
            if (!lastLine.isEmpty())
            {
                String[] parts = lastLine.split(":");
                if (parts.length>00)
                {
                    // 移除ID字符串中的空格
                    String id = parts[parts.length - 1].trim();
                    return id;
                }
            }
            bufferedReader.close();
        }
        catch (Exception ex)
        {
            System.out.print("An error occurred:"+ ex.getMessage());
        }
        return null;
    }
}
