import spire.cloud.excel.sdk.ApiException;
import spire.cloud.excel.sdk.Configuration;
import spire.cloud.excel.sdk.api.ExcelAIApi;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class Search {
    public static String baseUrl =  "base url";
    public static String appId =  "your ai id";
    public static String appKey =  "your ai key";
    static Configuration excelConfiguration_AI = new Configuration(appId, appKey,baseUrl);
    static ExcelAIApi excelAIApi = new ExcelAIApi(excelConfiguration_AI);


    public static void searchEnableHistory()
    {
        String name = "Search_True.txt";
        String question = "如何提高居民消费欲望,请列举三点";
        String language = "chinese";
        boolean enableHistory = true;
        String folder = "output";

        try {
            excelAIApi.search(name, question, language, enableHistory, null, folder, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }
    public static void searchEnableHistoryWithId()
    {
        String name = "Search_EnableHistoryWithId.txt";
        String question = "我刚刚提到了什么？";
        String language = "chinese";
        boolean enableHistory = true;
        String folder = "output";
        String conversationID = getConversationID("output/DocumentSearch_EnableHistory.txt");

        try {
            excelAIApi.search(name, question, language, enableHistory, conversationID, folder, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }
    public static void searchUnableHistory()
    {
        String name = "Search_UnableHistory.txt";
        String question = "how we can add a clickable URL to the Image as well?";
        String language = "Chinese";
        boolean enableHistory = false;
        String folder = "output";

        try {
            excelAIApi.search(name, question, language, enableHistory, null, folder, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }
    public static void searchUnableHistoryWithId()
    {
        String name = "Search_UnableHistoryWithId.txt";
        String question = "我刚刚提到了什么？";
        String language = "Chinese";
        boolean enableHistory = false;
        String folder = "output";
        String conversationID = getConversationID("output/DocumentSearch_EnableHistory.txt");

        try {
            excelAIApi.search(name, question, language, enableHistory, conversationID, folder, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }
    public static String getConversationID(String filename) {

        String file = java.nio.file.Paths.get(filename).toString();
        // 读取文件的最后一行
        String lastLine =null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream, StandardCharsets.UTF_8);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);

            String line;
            while ((line = bufferedReader.readLine()) != null) {
                lastLine = line;
            }
            if (!lastLine.isEmpty())
            {
                String[] parts = lastLine.split(":");
                if (parts.length>00)
                {
                    // 移除ID字符串中的空格
                    String id = parts[parts.length - 1].trim();
                    return id;
                }
            }
            bufferedReader.close();
        }
        catch (Exception ex)
        {
            System.out.print("An error occurred:"+ ex.getMessage());
        }
        return null;
    }
}
