import spire.cloud.excel.sdk.ApiException;
import spire.cloud.excel.sdk.Configuration;
import spire.cloud.excel.sdk.api.ExcelAIApi;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class DocumentSearch {
    public static String baseUrl = "base url";
    public static String appId = "your ai id";
    public static String appKey = "your ai key";
    static Configuration excelConfiguration_AI = new Configuration(appId, appKey, baseUrl);
    static ExcelAIApi excelAIApi = new ExcelAIApi(excelConfiguration_AI);

    public static void dcumentSearchEnableHistory() {
        String name = "sample.txt";
        String destFilePath = "output/DocumentSearch_EnableHistory.txt";
        String question = "这篇文章讲了什么？ 请用中文回答：";
        boolean enableHistory = true;
        String folder = "input";

        try {
            excelAIApi.documentSearch(name, destFilePath, question, null, enableHistory, null, folder, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public static void documentSearchEnableHistoryWithId() {
        String name = "sample.txt";
        String destFilePath = "output/DocumentSearch_EnableHistoryWithId.txt";
        String question = "我刚才的问题要求什么语言回答？";
        boolean enableHistory = true;
        String conversationID = getConversationID("output/DocumentSearch_EnableHistory.txt");
        String folder = "input";

        try {
            excelAIApi.documentSearch(name, destFilePath, question, null, enableHistory, conversationID, folder, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public static void documentSearchUnableHistory() {
        String name = "sample.txt";
        String destFilePath = "output/DocumentSearch_UnableHistory.txt";
        String question = "这篇文章讲了什么？ 请用中文回答：";
        boolean enableHistory = false;
        String folder = "input";

        try {
            excelAIApi.documentSearch(name, destFilePath, question, null, enableHistory, null, folder, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public static void documentSearchUnableHistoryWithId() {
        String name = "sample.txt";
        String destFilePath = "output/DocumentSearch_UnableHistoryWithId.txt";
        String question = "我刚才问了什么问题？";
        boolean enableHistory = false;
        String folder = "input";
        String conversationID = getConversationID("output/DocumentSearch_EnableHistory.txt");

        try {
            excelAIApi.documentSearch(name, destFilePath, question, null, enableHistory, conversationID, folder, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public static void documentSearchOptions() {
        String name = "sample.txt";
        String destFilePath = "output/DocumentSearch_Options.txt";
        String question = "这篇文章讲了什么？ 请用中文回答：";
        boolean enableHistory = false;
        Map<String, String> options = new HashMap<>();
        options.put("search_type", "similarity");
        options.put("search_kwargs", "{\\\"k\\\": 10}");
        String folder = "input";

        try {
            excelAIApi.documentSearch(name, destFilePath, question, options, enableHistory, null, folder, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getConversationID(String filename) {

        String file = java.nio.file.Paths.get(filename).toString();
        // 读取文件的最后一行
        String lastLine = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream, StandardCharsets.UTF_8);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);

            String line;
            while ((line = bufferedReader.readLine()) != null) {
                lastLine = line;
            }
            if (!lastLine.isEmpty()) {
                String[] parts = lastLine.split(":");
                if (parts.length > 00) {
                    // 移除ID字符串中的空格
                    String id = parts[parts.length - 1].trim();
                    return id;
                }
            }
            bufferedReader.close();
        } catch (Exception ex) {
            System.out.print("An error occurred:" + ex.getMessage());
        }
        return null;
    }
}
