import spire.cloud.excel.sdk.ApiException;
import spire.cloud.excel.sdk.Configuration;
import spire.cloud.excel.sdk.api.ExcelAIApi;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;


public class Ask {
    public static String baseUrl =  "base url";
    public static String appId =  "your ai id";
    public static String appKey =  "your ai key";
    static Configuration excelConfiguration_AI = new Configuration(appId, appKey,baseUrl);
    static ExcelAIApi excelAIApi = new ExcelAIApi(excelConfiguration_AI);

    public static void askEnableHistory()
    {
        String name = "Ask_EnableHistory.txt";
        String question = "推荐春天游玩的方式，请返回markdown格式";
        boolean enableHistory = true;
        String folder = "output";

        try {
            excelAIApi.ask(name,question,enableHistory,null,folder,null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }
    public static void askEnableHistoryWithId()
    {
        String name = "Ask_EnableHistoryWithId.txt";
        String question = "我刚才问了关于春天的什么？";
        boolean enableHistory = true;
        String folder = "output";
        String conversationID = getConversationID("output/Ask_EnableHistory.txt");

        try {
            excelAIApi.ask(name, question, enableHistory, conversationID, folder, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public static void askUnableHistory()
    {
        String name = "Ask_UnableHistory.txt";
        String question = "推荐春天游玩的方式，请返回markdown格式";
        boolean enableHistory = false;
        String folder = "output";

        try {
            excelAIApi.ask(name, question, enableHistory, null, folder, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public static void askUnableHistoryWithId()
    {
        String name = "Ask_UnableHistoryWithId.txt";
        String question = "刚才问了什么？";
        boolean enableHistory = false;
        String folder = "output";
        String conversationID = getConversationID("output/Ask_UnableHistory.txt");

        try {
            excelAIApi.ask(name, question, enableHistory, conversationID, folder, null);
        } catch (ApiException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getConversationID(String filename) {

        String file = java.nio.file.Paths.get(filename).toString();
        // 读取文件的最后一行
        String lastLine =null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream, StandardCharsets.UTF_8);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);

            String line;
            while ((line = bufferedReader.readLine()) != null) {
                lastLine = line;
            }
            if (!lastLine.isEmpty())
            {
                String[] parts = lastLine.split(":");
                if (parts.length>00)
                {
                    // 移除ID字符串中的空格
                    String id = parts[parts.length - 1].trim();
                    return id;
                }
            }
            bufferedReader.close();
        }
        catch (Exception ex)
        {
            System.out.print("An error occurred:"+ ex.getMessage());
        }
        return null;
    }

}
